/*
 * $Id: sample.c,v 1.2 2004/04/21 16:28:36 york Exp $
 *
 * Copyright (c) 2004 by TapTarget. All rights reserved.
 */

#include <PalmOS.h>

#include "../iscript.h"
#include "sample.resources"

#define SampleLibraryName "Sample"
#define SampleLibraryID   10

UInt16 gScriptRef;
MemHandle moduleH;

static Err SampleLoadModule(const Char *uri, UInt16 len, void **modulePP, UInt16 *offsetP)
{
    *modulePP = MemHandleLock(moduleH);
    *offsetP  = 0;

    return errNone;
}

static Err SampleUnloadModule(void *moduleP)
{
    MemHandleUnlock(moduleH);
    return errNone;
}

static Err SampleLibraryCall(UInt16 lindex, UInt8 findex, UInt16 *argcP,
    ScriptSlot *sp, ScriptSlot *rp)
{
    if(lindex == SampleLibraryID && findex == 0)
    {
        Err err;

        err = ScriptLibTypeCast(gScriptRef, sp, scriptTypeString);
        ErrNonFatalDisplayIf(err, "Failed to cast to string");

        FrmCustomAlert(SampleAlert, sp->value.s ? sp->value.s : "", "", "");

        *argcP = 1;
        return errNone;
    }

    return scriptErrFunctionNotFound;
}

/////////////////////////////////////////////////////////////////////////////////////////

#define FldInsertConst(fld, str) FldInsert(fld, str, sizeof(str) - 1)

static Boolean SampleFormHandleEvent(EventPtr evt)
{
    FieldPtr fld;
    FormPtr frm = FrmGetActiveForm();
    Boolean handled = false;

    switch(evt->eType)
    {
    case frmOpenEvent:
        fld = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, SampleScript));
        FldInsertConst(fld, "m#sample(3)");

        FrmDrawForm(frm);
        handled = true;
        break;

    case ctlSelectEvent:
        if(evt->data.ctlSelect.controlID == SampleEval)
        {
            Err err;
            ScriptSlot result = { scriptTypeInvalid };

            // execute script URI
            fld = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, SampleScript));
            err = ScriptLibExecute(gScriptRef, FldGetTextPtr(fld), &result);
            if(err) FrmCustomAlert(SampleAlert, "Invalid script URI or script error.", "", "");

            // cleanup result slot
            ScriptLibTypeCast(gScriptRef, &result, scriptTypeInvalid);
            handled = true;
        }
        break;

    default:
        break;
    }

    return handled;
}

static Boolean SampleAppHandleEvent(EventPtr evt)
{
    Boolean MainFormHandleEvent(EventPtr evt);

    if(evt->eType == frmLoadEvent)
    {
        UInt16 formId = evt->data.frmLoad.formID;
        FormPtr frm = FrmInitForm(formId);
        FrmSetActiveForm(frm);

        switch(formId)
        {
        case SampleForm:
            FrmSetEventHandler(frm, SampleFormHandleEvent);
            break;
        }

        return true;
    }

    return false;
}

static Boolean SampleAppStart()
{
    static ScriptHost host = {
        SampleLoadModule,
        SampleUnloadModule,
        SampleLibraryCall,
    };

    Err err;

#ifdef DEBUG
    SysLibTblEntryPtr entryP;
    void *codeP;
#endif

    if(SysLibFind(scriptLibName, &gScriptRef))
    {
        err = SysLibLoad(scriptLibType, scriptLibCreator, &gScriptRef);
        ErrFatalDisplayIf(err, "SysLibLoad() failed");
    }

#ifdef DEBUG
    entryP = SysLibTblEntry(gScriptRef);
    codeP = MemHandleLock(entryP->codeRscH);

    MemPtrUnlock(codeP);
#endif

    err = ScriptLibOpen(gScriptRef, &host, 64);
    ErrFatalDisplayIf(err, "ScriptLibOpen() failed");

    moduleH = DmGet1Resource('iSct', 0);
    return true;
}

static Boolean SampleAppStop()
{
    Err err;
    UInt16 numApps;

    err = ScriptLibClose(gScriptRef, &numApps);
    ErrFatalDisplayIf(err, "ScriptLibClose() failed");

    if(!numApps)
        SysLibRemove(gScriptRef);

    DmReleaseResource(moduleH);
    return true;
}

static Boolean SampleAppEventLoop()
{
    EventType event;
    UInt16 error;

    FrmGotoForm(SampleForm);

    do {
        EvtGetEvent(&event, -1);

        if(!MenuHandleEvent(NULL, &event, &error))
            if(!SampleAppHandleEvent(&event))
                if(!SysHandleEvent(&event))
                    FrmDispatchEvent(&event);
    } while(event.eType != appStopEvent);

    FrmCloseAllForms();

    return true;
}

UInt32 PilotMain(UInt16 cmd, void *cmdPBP, UInt16 launchFlags)
{
    if(cmd == sysAppLaunchCmdNormalLaunch)
    {
        if(SampleAppStart())
            SampleAppEventLoop();
        SampleAppStop();
    }

    return 0;
}
